﻿using chmDemo.Models;
using Microsoft.AspNetCore.Mvc;
using System.Diagnostics;

namespace chmDemo.Controllers
{
    /// <summary>
    /// home控制器
    /// </summary>
    public class HomeController : Controller
    {
        /// <summary>
        /// 日志记录
        /// </summary>
        private readonly ILogger<HomeController> _logger;

        /// <summary>
        /// 基类
        /// </summary>
        /// <param name="logger"></param>
        public HomeController(ILogger<HomeController> logger)
        {
            _logger = logger;
        }

        /// <summary>
        /// index页面
        /// </summary>
        /// <returns></returns>
        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// privacy页面
        /// </summary>
        /// <returns></returns>
        public IActionResult Privacy()
        {
            return View();
        }

        /// <summary>
        /// 异常页面
        /// </summary>
        /// <returns></returns>
        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
